class twitch::haproxy::almanac_limiter (
  $instance_name           = 'almanac',
  $user                    = 'www-data',
  $group                   = 'www-data',
  $stats_port              = 2013,
  $limiter_address         = '0.0.0.0',
  $limiter_port            = 9000,
  $almanac_port             = 8000,
){
  $global_options = {
    'log-tag'                   => "haproxy_${instance_name}",
    'pidfile'                   => "/var/run/haproxy-${instance_name}.pid",
  }

  $defaults_options = {
    'mode'    => 'http',
    'log'     => 'global',
    'option'  => [
      'dontlog-normal',
      'httplog',
      'log-health-checks',
    ],
    'timeout' => [
      'connect 10s',
      'client 10s',
      'server 10s'
    ],
  }

  twitch_haproxy::instance { $instance_name:
    defaults_options     => $defaults_options,
    global_options       => $global_options,
    stats_port           => $stats_port,
    create_stats_sockets => true,
  }

  class { 'twitch::haproxy::listeners::almanac_limiter':
    instance_name  => $instance_name,
    listen_address => $limiter_address,
    listen_port    => $limiter_port,
    remote_port    => $almanac_port,
  }
}
