# Instance class to setup the default and global settings used in backend
# Creates stats listener on port set in class parameter stats_port (default 2015)
# Class parameter include_all (default true) will create a full catalog of backend listeners,
#  if set to false, individual listeners can be included to pare down the listing
class twitch::haproxy::backend (
  $ensure      = 'present',
  $instname    = 'backend',
  $stats_port  = 2015,
  $global_options = {
    'user'    => 'www-data',
    'group'   => 'www-data',
    'daemon'  => '',
    'quiet'   => '',
    'pidfile' => '/var/run/haproxy-backend.pid',
    'maxconn' => '32000',
    'chroot'  => '/var/chroot/haproxy',
    'nbproc'  => '1',
    'log-tag' => 'haproxy_backend',
    'log'     => '127.0.0.1 local3',
    'stats'   => 'socket /var/run/haproxy_backend.stat user root group root mode 666 level operator'
  },
  $defaults_options = {
    'log'            => 'global',
    'mode'           => 'tcp',
    'balance'        => 'roundrobin',
    'option'         => [
      'tcplog',
      'tcpka',
      'redispatch',
      'contstats'
    ],
    'default-server' => [
      'init-addr libc,last,none',
    ],
  },
  $include_all = true,
  $with_consul_template = true,
){
  validate_re($ensure, [ '^present$', '^absent$' ])

  $instance_name = $instname

  twitch_haproxy::instance { $instname:
    ensure               => $ensure,
    defaults_options     => $defaults_options,
    global_options       => $global_options,
    stats_port           => $stats_port,
    with_consul_template => $with_consul_template,
  }

  if $include_all and $ensure == 'present' {
    include twitch::haproxy::listeners::backend_usherdb_master
    include twitch::haproxy::listeners::backend_rabbit_cluster_hls_production
    include twitch::haproxy::listeners::backend_video_api_http
    include twitch::haproxy::listeners::backend_s3_http_proxy
  }
}
