class twitch::haproxy::backends::almanac_out($primary_url, $secondary_url, $default_remote_port) {

  $haproxy_instance = 'almanac-lb'
  $server_options = 'check inter 1000'
  $options = {
    'mode'    => 'http',
    'option'  => [
      'httpchk GET /debug/running',
      'forwardfor',  # Include X-Forwarded-For header.
      'allbackups',
    ],
    'http-check' => 'expect rstatus ^2',
    'timeout' => ['http-keep-alive 1000'],
    'default-server' => [
        'fall 5',
        'rise 2',
    ]
  }

  twitch_haproxy::backend { 'almanac-out':
    instance_name       => $haproxy_instance,
    default_remote_port => $default_remote_port,
    server_list         => [
      "${primary_url}:80 weight 90",
      "${secondary_url}:80 weight 10",
      "${primary_url}:80 weight 90 backup",
      "${secondary_url}:80 weight 10 backup"
    ],
    options             => $options,
    server_options      => $server_options,
  }

  twitch_haproxy::resolver { 'almanac_elbs':
    instance_name => $haproxy_instance,
    holds => {
      valid => '10s',
    },
  }

}