class twitch::haproxy::backends::countess (
  $haproxy_instance = 'countess',
  $proxy_name       = 'countess',
  $servers          = [
    'localhost',
  ],
  $remote_port      = 8080,
  $server_options   = 'check inter 5000 maxconn 52000',
  $settings         = {
    'mode'   => 'http',
    'option' => [
      'httpchk GET /debug/health',
      'httpclose'
    ]
  },
) {
  twitch_haproxy::backend{ $proxy_name:
    instance_name       => $haproxy_instance,
    default_remote_port => $remote_port,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
