class twitch::haproxy::backends::database_sitedb_slave_aws (
  $haproxy_instance = 'backend',
  $proxy_name     = 'database-sitedb-slave',
  $servers        = [
    '127.0.0.1:6542',
    '127.0.0.1:6543',
  ],
  $remote_port    = 12006,
  $server_options = 'check inter 5000 weight 20',
  $settings       = {
    'balance' => 'leastconn',
  },
) {
  twitch_haproxy::backend{ $proxy_name:
    instance_name       => $haproxy_instance,
    default_remote_port => $remote_port,
    options             => $settings,
    server_list         => fqdn_rotate($servers),
    server_options      => $server_options,
  }
}
