class twitch::haproxy::backends::speedtest_backend (
  $instname,
  $primary_url,
  $secondary_url,
  $remote_port,
  $proxy_name      = 'speedtest_backend',
  $settings        = {
    'mode'   => 'http',
    'option' => [
            'dontlog-normal',
            'httplog',
        ],
    },
  $server_options   = 'resolvers speed_backend check inter 5000 maxconn 52000 init-addr libc,last,none',
) {
  validate_integer($remote_port)

  twitch_haproxy::backend{ $proxy_name:
    instance_name       => $instname,
    default_remote_port => $remote_port,
    server_list         => [
      "${primary_url}:80 weight 90",
    ],

    options             => $settings,
    server_options      => $server_options,
  }
  twitch_haproxy::resolver { 'speed_backend':
    instance_name => $instname,
      holds => {
        valid => '10s',
    },
  }
}
