class twitch::haproxy::backends::telegraph_backend (
  $haproxy_instance = 'telegraph',
  $proxy_name       = 'telegraph-backend',
  $servers          = [
    '127.0.0.2:891',
    '127.0.0.3:892',
    '127.0.0.4:893',
    '127.0.0.5:894',
    '127.0.0.6:891',
    '127.0.0.7:892',
    '127.0.0.8:893',
    '127.0.0.9:894',
  ],
  $remote_port      = 891,
  $server_options   = 'check inter 5000 maxconn 52000',
  $settings         = {
    'maxconn' => '1000000',
  },
) {
  twitch_haproxy::backend{ $proxy_name:
    instance_name       => $haproxy_instance,
    default_remote_port => $remote_port,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
