class twitch::haproxy::backends::tenfoot_out($blue_listen_port, $green_listen_port) {
  validate_re($blue_listen_port, '^\d+$')
  validate_re($green_listen_port, '^\d+$')

  # This will be appended to addresses in `server_list` that consist of a hostname/address without a port number.  It
  # should NEVER be used by this module, since we always specify the port that we want.
  $default_remote_port = -1

  $haproxy_instance = 'tenfoot'
  $server_options = 'check inter 1000'
  $options = {
    'mode'    => 'http',
    'option'  => [
      'httpchk HEAD /running',
      'forwardfor',  # Include X-Forwarded-For header.
    ],
    'no option' => [
      'allbackups',  # This only has any effect for 'tenfoot-out', which has servers marked as backups.
    ],
    'timeout' => ['http-keep-alive 1000'],
  }

  # This backend is the default ("tenfoot-out"); it provides failover between the blue and green instances.
  # N.B.: This is *not* a blue-green deployment strategy like the server names would suggest -- it is active-backup.
  #   When the "blue" instance is available, it gets all of the traffic; when it is not, the "green" instance does.
  twitch_haproxy::backend { 'tenfoot-out':
    instance_name       => $haproxy_instance,
    default_remote_port => $default_remote_port,
    server_list         => [
      "localhost:${blue_listen_port} fall 1 rise 2",
      "localhost:${green_listen_port} fall 1 rise 2 backup",
    ],
    options             => $options,
    server_options      => $server_options,
  }

  # This backend is used only when a request made locally includes the header 'X-Twitch-Force: blue'.
  twitch_haproxy::backend { 'force-blue':
    instance_name       => $haproxy_instance,
    default_remote_port => $default_remote_port,
    server_list         => ["localhost:${blue_listen_port} fall 1 rise 2"],
    options             => $options,
    server_options      => $server_options,
  }

  # This backend is used only when a request made locally includes the header 'X-Twitch-Force: green'.
  twitch_haproxy::backend { 'force-green':
    instance_name       => $haproxy_instance,
    default_remote_port => $default_remote_port,
    server_list         => ["localhost:${green_listen_port} fall 1 rise 2"],
    options             => $options,
    server_options      => $server_options,
  }
}
