class twitch::haproxy::backends::usher_mmr_backend (
  $instname,
  $primary_url,
  $secondary_url,
  $remote_port,
  $regional_url,
  $proxy_name      = 'usher_mmr_backend',
  $settings        = {
    'mode'   => 'http',
    'option' => [
      'httplog',
    ],
  },
  $server_options   = 'resolvers mmr_elb_backend check inter 5000 maxconn 52000 init-addr libc,last,none',
) {
  validate_integer($remote_port)

  twitch_haproxy::backend{ $proxy_name:
    instance_name       => $instname,
    default_remote_port => $remote_port,
    server_list         => [
      "${primary_url}:80 weight 90",
      "${secondary_url}:80 weight 10",
      "${primary_url}:80 weight 90 backup",
      "${secondary_url}:80 weight 10 backup"
    ],
    options             => $settings,
    server_options      => $server_options,
  }

  $regional_opts = {
    'http-request' => 'replace-path /pathfinder/(.*) /\1 if { url_beg /pathfinder/ }'
  }

  $regional_settings = deep_merge($settings, $regional_opts)

  twitch_haproxy::backend{ 'regional_mmr_backend':
    instance_name       => $instname,
    default_remote_port => $remote_port,
    server_list         => [
      "${regional_url}:8080 weight 100",
    ],
    options             => $regional_settings,
    server_options      => $server_options,
  }

  twitch_haproxy::resolver { 'mmr_elb_backend':
    instance_name => $instname,
    holds         => {
      valid => '10s',
    },
  }
}
