class twitch::haproxy::backends::usher_origin (
  $instname,
  $ports,
  $proxy_name      = "${instname}-out",
  $maxconn         = 40,
  $settings        = {
    'mode'   => 'http',
    'option' => [
      'dontlog-normal',
      'httplog',
      'httpchk HEAD /running HTTP/1.0',
    ],
  },
) {
  validate_integer($maxconn)

  $servers_string = inline_template('<%= @ports.map { |port| "localhost:#{port}"}.join(",") %>')
  $servers = split($servers_string, ',')

  $server_options  = "check inter 1000 maxconn ${maxconn} fall 1 rise 2"

  twitch_haproxy::backend{ $proxy_name:
    instance_name       => $instname,
    default_remote_port => $remote_port,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
