class twitch::haproxy::backends::video_origin($haproxy_instance, $port) {
  twitch_haproxy::backend { 'video-origin':
    instance_name       => $haproxy_instance,
    server_list         => [
      "localhost:${port} fall 1 rise 2",
    ],
    default_remote_port => $port,
    server_options      => 'check inter 1000',
    options             => {
      'mode'    => 'http',
      'option'  => [
        'httpchk GET /debug/health',
        'forwardfor',
      ],
      'timeout' => ['http-keep-alive 1000'],
    },
  }
}
