class twitch::haproxy::backends::videoshim (
  $haproxy_instance     = 'videoshim',
  $proxy_name           = 'videoshim-out',
  $servers              = fqdn_rotate(consul_service_lookup('videoshim', {'dc' => 'sjc02', 'tag' => 'production'})),
  $server_options       = 'check inter 5000 maxconn 52000',
  $settings = {
    'mode'   => 'http',
    'option' => [
      'httpchk HEAD /running',
    ],
  },
) {
  twitch_haproxy::backend{ $proxy_name:
    instance_name       => $haproxy_instance,
    default_remote_port => $remote_port,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
