class twitch::haproxy::frontends::almanac_in($listen_port) {
  validate_re($listen_port, '^\d+$')

  include twitch_vars

  $allow_ips = concat($::twitch_vars::twitch_networks, '127.0.0.0/8')
  $ip_whitelist_acl_rules = prefix($allow_ips, 'whitelisted_ip src ')

  $haproxy_instance = 'almanac-lb'
  $proxy_name = 'almanac-in'
  $listen_address = '0.0.0.0'
  $settings         = {
    'default_backend' => 'almanac-out',
    'mode'            => 'http',
    'timeout'         => [
      'http-request    1000',
      'http-keep-alive 10000',
    ],
    'acl'            => $ip_whitelist_acl_rules,
    'http-request' =>  [
      'deny if !whitelisted_ip',
    ],
  }

  twitch_haproxy::frontend{ $proxy_name:
    instance_name       => $haproxy_instance,
    ports               => [$listen_port],
    ipaddress           => $listen_address,
    options             => $settings,
  }
}

