class twitch::haproxy::frontends::countess_in (
  $haproxy_instance = 'countess',
  $proxy_name       = 'countess_in',
  $listen_port      = 6060,
  $listen_address   = '0.0.0.0',
  $settings         = {
    'mode'            => 'http',
    'default_backend' => 'countess',
    'rate-limit'      => 'sessions 2000',
    'option'          => [
      'dontlog-normal',
      'httpclose'
    ]
  },
) {

  twitch_haproxy::frontend{ $proxy_name:
    instance_name => $haproxy_instance,
    ports         => [$listen_port],
    ipaddress     => $listen_address,
    options       => $settings,
  }
}

