class twitch::haproxy::frontends::hls_edge_daemon_in (
  $haproxy_instance = 'hlsedge',
  $proxy_name       = 'hls-edge-daemon-in',
  $listen_port      = 8080,
  $listen_address   = '127.0.0.1',
  $settings         = {
    'default_backend' => 'hls-edge-daemon-out',
    'mode'            => 'http',
    'timeout'         => [
      'http-request 1000',
      'http-keep-alive 10000',
    ],
  },
) {

  twitch_haproxy::frontend{ $proxy_name:
    instance_name => $haproxy_instance,
    ports         => [$listen_port],
    ipaddress     => $listen_address,
    options       => $settings,
  }
}

