class twitch::haproxy::frontends::tenfoot_in($listen_port, $default_backend) {
  validate_re($listen_port, '^\d+$')

  include twitch_vars

  $allow_ips = concat($::twitch_vars::twitch_networks, '127.0.0.0/8')
  $ip_whitelist_acl_rules = prefix($allow_ips, 'whitelisted_ip src ')

  $haproxy_instance = 'tenfoot'
  $proxy_name = 'tenfoot-in'
  $listen_address = '0.0.0.0'
  $settings         = {
    'default_backend' => $default_backend,
    'mode'            => 'http',
    'timeout'         => [
      'http-request    1000',
      'http-keep-alive 10000',
    ],
    'acl'            => concat([
      'is_local             src                    localhost',
      'is_force_green       hdr(X-Twitch-Force) -i green',
      'is_force_blue        hdr(X-Twitch-Force) -i blue',
      'is_low_latency       path_beg               /hls/lowlatency-darklaunch/'
    ], $ip_whitelist_acl_rules),
    'use_backend'    => [
      'force-green    if is_force_green    is_local',
      'force-blue     if is_force_blue     is_local',
      'video-origin   if is_low_latency',
    ],
    'http-request' =>  [
      'deny if !whitelisted_ip',
    ],
  }

  twitch_haproxy::frontend{ $proxy_name:
    instance_name => $haproxy_instance,
    ports         => [$listen_port],
    ipaddress     => $listen_address,
    options       => $settings,
  }
}
