class twitch::haproxy::frontends::tolive_rtmp (
  $instance_name    = 'tolive',
  $frontend_name    = 'tolive_rtmp',
  $default_backend  = 'tolive',
  $use_so_reuseport = true,
  $nbproc           = $::processorcount / 2,
  $origin_pop_key   = 'origin_pop',
){
  twitch_haproxy::consul_frontend { $frontend_name:
    instance_name    => $instance_name,
    ports            => [1935],
    ipaddress        => $::ipaddress_primary,
    options          => {
      'default_backend' => $default_backend,
      'maxconn'         => '32000',
    },
    use_so_reuseport => $use_so_reuseport,
    nbproc           => $nbproc,
    custom_content   => template("${module_name}/haproxy/services/tolive_rtmp_origin.erb"),
  }
}
