class twitch::haproxy::frontends::tolive_rtmps (
  $instance_name    = 'tolive',
  $frontend_name    = 'tolive_rtmps',
  $default_backend  = 'tolive',
  $use_so_reuseport = true,
  $nbproc           = $::processorcount / 2,
){
  twitch_haproxy::ssl_certificate { 'wildcard_contribute_live-video_net':
    instance_name       => $instance_name,
    sandstorm_key_prefix => 'video/ingest-proxy/production/wildcard_contribute_live-video_net',
    use_twitch_wildcard => false,
  }

  twitch_haproxy::ssl_certificate { 'wildcard_global-contribute_live-video_net':
    instance_name        => $instance_name,
    sandstorm_key_prefix => 'video/ingest-proxy/production/wildcard_global-contribute_live-video_net',
    use_twitch_wildcard  => false,
  }

  twitch_haproxy::ssl_certificate { 'wildcard_twitch_tv':
    instance_name       => $instance_name,
    use_twitch_wildcard => true,
  }

  twitch_haproxy::consul_frontend { $frontend_name:
    instance_name    => $instance_name,
    ports            => [443],
    bind_options     => ['ssl no-sslv3 crt /etc/haproxy/ssl/'],
    ipaddress        => $::ipaddress_primary,
    options          => {
      'default_backend' => $default_backend,
      'maxconn'         => '32000',
    },
    use_so_reuseport => $use_so_reuseport,
    nbproc           => $nbproc,
  }
}
