class twitch::haproxy::frontends::usher_origin (
  $instname,
  $listen_port,
  $max_avg_queue,
  $min_backends,
  $proxy_name       = "${instname}-in",
  $listen_address   = '*',
) {
  validate_integer($min_backends)
  validate_integer($max_avg_queue)

  $settings         = {
    'default_backend' => "${instname}-out",
    'mode'            => 'http',
    'monitor-uri'     => '/alive',
    'acl'             => [
      "usher_origin_dead nbsrv(${instname}-out) lt ${min_backends}",
      "usher_origin_overload avg_queue(${instname}-out) gt ${max_avg_queue}",
    ],
    'monitor'         => [
      'fail if usher_origin_dead or usher_origin_overload',
    ],
  }

  twitch_haproxy::frontend{ $proxy_name:
    instance_name => $instname,
    ports         => [$listen_port],
    ipaddress     => $listen_address,
    options       => $settings,
  }
}

