class twitch::haproxy::frontends::usher_origin_check (
  $instname,
  $min_backends,
  $max_avg_queue,
  $proxy_name       = "${instname}-check",
  $listen_port      = 8001,
  $listen_address   = '*',
) {
  validate_integer($min_backends)
  validate_integer($max_avg_queue)

  $settings = {
    'mode'        => 'http',
    'monitor-uri' => '/alive',
    'acl'         => [
      "usher_origin_dead nbsrv(${instname}-out) lt ${min_backends}",
      "usher_origin_overload avg_queue(${instname}-out) gt ${max_avg_queue}",
    ],
    'monitor' => [
      'fail if usher_origin_dead or usher_origin_overload',
    ],
    'option' => [
      'httplog',
    ],
  }

  twitch_haproxy::frontend{ $proxy_name:
    instance_name => $instname,
    ports         => [$listen_port],
    ipaddress     => $listen_address,
    options       => $settings,
  }
}

