class twitch::haproxy::frontends::video_cdncache_ssl (
  $instance_name    = 'video_cdncache_ssl',
  $frontend_name    = 'https-keepalive-rsa-http',
  $cert_prefix      = "video/cdn-origin/production/wildcard_cdn-origin_hls_live-video_net",
  $default_backend  = 'https-keepalive',
  $use_so_reuseport = true,
  $nbproc           = 1,
  $cert_type        = 'rsa',
  $ports            = [443],
){
  include twitch_nrdp

  twitch_haproxy::ssl_certificate { 'cdn_origin_cert':
    instance_name        => $instance_name,
    sandstorm_key_prefix => $cert_prefix,
    before               => Twitch_haproxy::Frontend[$frontend_name],
  }

  # Add sandstorm checks to this sandstormified-host.
  realize(Twitch_nrdp::Check['check_sandstorm_agent'])
  realize(Twitch_nrdp::Check['check_sandstorm_agent_ops'])

  $bind_options = ["v4v6 ssl no-sslv3 crt /etc/haproxy/ssl no-tls-tickets"]

  $options = {
    'default_backend' => $default_backend,
    'option'          => [
      'http-keep-alive',
      'forwardfor except 127.0.0.0/8 header X-Client-IP',
    ],
    'monitor-uri'     => '/alive',
    'http-request'    => [
      'del-header X-Client-IP',
      'set-header Proxied-HTTPS true',
    ],
    'log-format'      => '%ci:%cp\ [%t]\ %ft\ %b/%s\ %Tq/%Tw/%Tc/%Tr/%Tt\ %ST\ %B\ %CC\ %CS\ %tsc\ %ac/%fc/%bc/%sc/%rc\ %sq/%bq\ %hr\ %hs\ %{+Q}r\ %sslc\ %sslv',
  }

  twitch_haproxy::frontend { $frontend_name:
    instance_name    => $instance_name,
    ports            => $ports,
    bind_options     => $bind_options,
    ipaddress        => '::',
    options          => $options,
    use_so_reuseport => $use_so_reuseport,
    nbproc           => $nbproc,
  }
}
