class twitch::haproxy::frontends::video_offnet_origin (
  $instance_name    = 'video_offnet_origin',
  $frontend_name    = 'socket-proxy',
  $default_backend  = 'pachyderm',
  $use_so_reuseport = true,
  $nbproc           = 1,
  $enable_abs       = false
){
  include twitch_nrdp

  twitch_haproxy::frontend { $frontend_name:
    instance_name    => $instance_name,
    ports            => [443],
    bind_options     => [],
    ipaddress        => '*',
    options          => {
      'default_backend' => $default_backend,
      'mode'            => 'tcp',
      'option'          => [],
    },
    use_so_reuseport => $use_so_reuseport,
    nbproc           => $nbproc,
  }
}
