class twitch::haproxy::frontends::videoshim_check (
  $haproxy_instance = 'videoshim',
  $proxy_name       = 'videoshim-check',
  $listen_port      = 35151,
  $listen_address   = '*',
  $settings         = {
    'mode'        => 'http',
    'monitor-uri' => '/alive',
    'acl'         => [
      'videoshim_dead nbsrv(videoshim-out) lt 1',
    ],
    'monitor' => [
      'fail if videoshim_dead',
    ],
    'option' => [
      'httplog',
    ],
  },
) {
  twitch_haproxy::frontend{ $proxy_name:
    instance_name => $haproxy_instance,
    ports         => [$listen_port],
    ipaddress     => $listen_address,
    options       => $settings,
  }
}

