class twitch::haproxy::ingest_loadbalancer_public (
  $env = $::twitch_environment
){
  $instname             = 'ingest_loadbalancer'
  $ingest_proxy_lb_name = 'ingest-proxy-lb-pub'
  $upstream             = "${env}.goingest"
  $stats_port           = 2001
  $processes            = $processorcount/2
  $cpu_map              = regsubst($physicalprocessorrange, ',', ' ')
  $global_options       = {
    'user'    => 'www-data',
    'group'   => 'www-data',
    'daemon'  => '',
    'quiet'   => '',
    'pidfile' => "/var/run/haproxy-${instname}.pid",
    'maxconn' => '32000',
    'chroot'  => '/var/chroot/haproxy',
    'nbproc'  => $processes,
    'log-tag' => "haproxy_${instname}",
    'log'     => '127.0.0.1 local3',
    'stats'   => "socket /var/run/haproxy-${instname}.stat user root group root mode 666 level operator",
    'cpu-map' => "all ${cpu_map}",
  }
  $defaults_options     = {
    'log'     => 'global',
    'mode'    => 'tcp',
    'balance' => 'roundrobin',
    'option'  => [
      'tcplog',
      'tcpka',
      'redispatch',
      'contstats',
    ],
    'timeout' => [
      'connect 5000',
      'server 30000',
      'client 40000',
    ]
  }

  twitch_haproxy::instance { $instname:
    defaults_options     => $defaults_options,
    global_options       => $global_options,
    stats_port           => $stats_port,
    with_consul_template => true,
    create_stats_sockets => true,
  }

  class { 'twitch::haproxy::listeners::ingest_loadbalancer_ext_port_1935':
    upstream => $upstream,
  }

  consul::service { $ingest_proxy_lb_name:
    consul_tags => [ $env ],
    port        => 1935,
  }
}
