class twitch::haproxy::listeners::almanac_limiter (
  $instance_name       = 'almanac',
  $listener_name       = 'almanac_limiter',
  $listen_address      = '0.0.0.0',
  $listen_port         = 9000,
  $remote_port          = 8000,
  $nbproc              = 1,
  $bind_processes      = 'all',
){
  $almanac_options = {
    'mode'            => 'http',
    'timeout'         => [
      'http-request 10000',
      'queue 300ms',
    ],
    'option'          => [
      'http-keep-alive',
    ],
  }

  twitch_haproxy::listen{ $listener_name:
    instance_name       => $instance_name,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $almanac_options,
    use_so_reuseport    => true,
    nbproc              => $nbproc,
    bind_options        => ["process ${bind_processes}"],
    server_list         => [
      "127.0.0.1:${remote_port} check inter 1s maxconn 60 maxqueue 500",
    ],
  }
}
