class twitch::haproxy::listeners::backend_database_sitedb_production_master (
  $haproxy_instance = 'backend',
  $proxy_name     = 'database-sitedb-production-master',
  $listen_port    = 12005,
  $remote_port    = 12005,
  $listen_address = '127.0.0.1',
  $server_options = 'check inter 5000',
  $servers        = [
    '127.0.0.1:6542',
    '127.0.0.1:6543',
              ],
  $settings       = {
    'timeout' => [
      'client 0',
      'server 0',
    ],
  },
) {

  twitch_haproxy::listen{ $proxy_name:
    instance_name       => $haproxy_instance,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
