class twitch::haproxy::listeners::backend_database_sitedb_production_slave (
  $haproxy_instance = 'backend',
  $proxy_name     = 'database-sitedb-production-slave',
  $servers        = [],
  $listen_port    = 12006,
  $remote_port    = 12006,
  $listen_address = '127.0.0.1',
  $server_options = '',
  $settings       = {
    'default_backend' => 'database-sitedb-slave',
    'timeout'         => [
      'client 0',
      'server 0',
    ],
  },
) {

  include twitch::haproxy::backends::database_sitedb_slave_aws

  twitch_haproxy::listen{ $proxy_name:
    instance_name       => $haproxy_instance,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
