class twitch::haproxy::listeners::backend_memcache (
  $haproxy_instance = 'backend',
  $proxy_name     = 'backend-memcache',
  $servers        = [
    'backend-memcache-8357ac.sfo01.justin.tv',
    'backend-memcache-8358f0.sfo01.justin.tv',
    'backend-memcache-835900.sfo01.justin.tv',
  ],
  $listen_port    = 12016,
  $remote_port    = 11211,
  $listen_address = '127.0.0.1',
  $server_options = '',
  $settings       = {},
) {

  twitch_haproxy::listen{ $proxy_name:
    instance_name       => $haproxy_instance,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
