class twitch::haproxy::listeners::backend_rabbit_cluster_hls_production (
  $haproxy_instance = 'backend',
  $proxy_name     = 'rabbit-cluster-hls-production',
  $servers        = [],
  $listen_port    = hiera('hls_rabbit_port'),
  $remote_port    = 5672,
  $listen_address = '127.0.0.1',
  $server_options = 'check inter 5000',
  $settings       = {
    'mode' => 'tcp',
    'timeout' => [
      'client 24d',    # XXX: amqp-0-8-0 DOES NOT HAVE A HEARTBEAT; set timeouts to some obnoxiously large value
      'server 24d',    # we're betting here that the usher processes will receive a reHUP from a deploy within a year (to reestablish cnx)
    ],
  },
) {

  validate_array($servers)
  if size($servers) < 1 { fail("\$servers is less than 1, this is unexpected, check hiera") }

  twitch_haproxy::listen{ $proxy_name:
    instance_name       => $haproxy_instance,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
