class twitch::haproxy::listeners::backend_rails_session_memcached_shard_b (
  $haproxy_instance = 'backend',
  $proxy_name     = 'rails-session-memcached-shard-b',
  $servers        = ['rails-session-memcached-1.prod.us-west2.justin.tv'],
  $listen_port    = 12120,
  $remote_port    = 11211,
  $listen_address = '127.0.0.1',
  $server_options = 'check inter 5000',
  $settings       = {},
) {

  twitch_haproxy::listen{ $proxy_name:
    instance_name       => $haproxy_instance,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
