class twitch::haproxy::listeners::backend_s3_http_proxy (
  $haproxy_instance = 'backend',
  $proxy_name       = 's3_http_proxy',
  $listen_port      = 12395,
  $listen_address   = '127.0.0.1',
  $server_options   = 'check inter 1000',
  $settings         = {
    'mode'       => 'http',
    'log'        => 'global',
    'balance'    => 'leastconn',
    'timeout'   => [
      'connect 1000',
      'client 20000',
      'server 20000',
    ],
  },
) {
  twitch_haproxy::consul_listen{ $proxy_name:
    instance_name   => $haproxy_instance,
    ports           => $listen_port,
    ipaddress       => $listen_address,
    options         => $settings,
    consul_services => [{
        service => 's3-http-proxy.squid-proxy',
        health  => 'passing',
      }],
    server_options  => $server_options,
  }
}

