class twitch::haproxy::listeners::backend_usherdb_master (
  # much of the legacy staging infrastructure does not expect a staging usher-postgres.
  # we'll need at least a staging memcache before this can work.
  #$env            = pick($::twitch_environment, $twitch_environment, 'production'),
  $env            = 'production',
  $service_name   = 'usher-postgres-master',
  $haproxy_instance = 'backend',
  $proxy_name     = 'usherdb-master',
  $listen_port    = 12075,
  $remote_port    = 6543,
  $listen_address = '127.0.0.1',
  $server_options = 'check inter 5000',
  $settings       = {
    'maxconn' => 4000,
    'timeout' => [
      'client 0',
      'server 0',
    ],
  },
) {

  twitch_haproxy::consul_listen{ $proxy_name:
    instance_name   => $haproxy_instance,
    ports           => $listen_port,
    ipaddress       => $listen_address,
    options         => $settings,
    consul_services => [
      { 'health'  => 'passing',
        'service' => "${env}.${service_name}" },
    ],
    server_options  => $server_options,
  }
}
