class twitch::haproxy::listeners::backend_video_api_http (
  $haproxy_instance = 'backend',
  $proxy_name       = 'video-api-http',
  $servers          = [ 'video-api.internal.justin.tv' ],
  $listen_port      = 12390,
  $remote_port      = 80,
  $listen_address   = '127.0.0.1',
  $use_so_reuseport = undef,
  $nbproc           = undef,
  $server_options   = 'maxconn 4400',
  $settings         = {
    'mode'    => 'http',
    'log'     => 'global',
    'balance' => 'roundrobin',
    'timeout' => [
      'connect 1000',
      'client 20000',
      'server 20000',
    ],
    'option'  => [
      'forwardfor except 127.0.0.1',
      'httplog',
    ],
  },
) {
  twitch_haproxy::listen{ $proxy_name:
    instance_name       => $haproxy_instance,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
    use_so_reuseport    => $use_so_reuseport,
    nbproc              => $nbproc,
  }
}

