class twitch::haproxy::listeners::backend_video_api_lb (
  $haproxy_instance = 'backend',
  $proxy_name       = 'video-api-http',
  $listen_port      = 12390,
  $listen_address   = '127.0.0.1',
  $use_so_reuseport = undef,
  $nbproc           = undef,
  $server_options   = 'check inter 1000 maxconn 200',
  $settings         = {
    'mode'       => 'http',
    'log'        => 'global',
    'balance'    => 'roundrobin',
    'timeout'   => [
      'connect 1000',
      'client 20000',
      'server 30000',
    ],
    'option'     => [
      'forwardfor except 127.0.0.1',
      'httplog',
      'httpchk HEAD /alive HTTP/1.0',
    ],
  },
) {
  twitch_haproxy::consul_listen{ $proxy_name:
    instance_name   => $haproxy_instance,
    ports           => $listen_port,
    ipaddress       => $listen_address,
    options         => $settings,
    consul_services => {
      service => 'production.video-api-origin',
      health  => 'passing',
    },
    server_options   => $server_options,
    use_so_reuseport => $use_so_reuseport,
    nbproc           => $nbproc,
  }
}

