class twitch::haproxy::listeners::ingest_loadbalancer_port_1943 (
  $upstream,
) {
  $haproxy_instance = 'ingest_loadbalancer'
  $proxy_name       = "${haproxy_instance}-port_1943"
  $listen_port      = 1943
  $remote_port      = 1943
  $listen_address   = $::ipaddress_primary
  $server_options   = "check port ${remote_port} inter 10s send-proxy"
  $settings         = {
    'maxconn' => '32000',
    'option'  => [
      'tcp-check',
    ],
  }

  twitch_haproxy::consul_listen{ $proxy_name:
    instance_name    => $haproxy_instance,
    ports            => $listen_port,
    ipaddress        => $listen_address,
    options          => $settings,
    consul_services  => [
      {
        service => $upstream,
      }
    ],
    server_options   => $server_options,
    use_so_reuseport => true,
    nbproc           => $::twitch::haproxy::ingest_loadbalancer::global_options['nbproc'],
  }
}
