class twitch::haproxy::listeners::live_port_1935 (
  $haproxy_instance = 'live',
  $proxy_name     = 'live-port_1935',
  $listen_port    = 1935,
  $remote_port    = 1935,
  $listen_address = $::ipaddress_primary,
  $server_options = 'check port 9393 inter 10s send-proxy',
  $settings       = {
    'maxconn' => '32000',
    'option'  => [
      'httpchk GET / HTTP/1.0\n\n',
    ],
  },
) {

  twitch_haproxy::consul_listen{ $proxy_name:
    instance_name    => $haproxy_instance,
    ports            => $listen_port,
    ipaddress        => $listen_address,
    options          => $settings,
    consul_services  => [
      {
        service => 'production.goingest@sjc02',
      }
    ],
    server_options   => $server_options,
    use_so_reuseport => true,
    nbproc           => $::twitch::haproxy::live::global_options['nbproc'],
  }
}
