class twitch::haproxy::listeners::private_port_1935 (
  $haproxy_instance = 'private',
  $proxy_name     = 'private-port_1935',
  $listen_port    = 1935,
  $remote_port    = 1935,
  $listen_address = '0.0.0.0',
  $server_options = 'check port 9393 inter 5000 send-proxy',
  $settings       = {
    'log'     => 'global',
    'balance' => 'leastconn',
    'option'  => [
      'httpchk GET / HTTP/1.0\n\n',
    ],
  },
) {

  twitch_haproxy::consul_listen{ $proxy_name:
    instance_name   => $haproxy_instance,
    ports           => $listen_port,
    ipaddress       => $listen_address,
    options         => $settings,
    consul_services => { service => 'production.goingest@sfo01' },
    server_options  => $server_options,
  }
}
