class twitch::haproxy::listeners::usher_mmr_lb_listener (
  $haproxy_instance,
  $proxy_name     = 'usher_consul_backend',
  $listen_port    = 80,
  $listen_address = '*',
  $server_options = 'check inter 1000 maxconn 200',
  $settings       = {
    'maxconn'    => '52000',
    'mode'       => 'http',
    'log'        => 'global',
    'balance'    => 'roundrobin',
    'timeout'   => [
      'connect 5000',
      'client 20000',
      'server 20000',
    ],
    'option'     => [
      'dontlog-normal',
      'httplog',
      'httpchk HEAD /alive HTTP/1.0',
    ],
  },
) {
  twitch_haproxy::consul_listen{ $proxy_name:
    instance_name    => $haproxy_instance,
    ports            => $listen_port,
    ipaddress        => $listen_address,
    options          => $settings,
    consul_services  => {
      health         => 'passing',
      service        => "production.usher-api-origin@${::pop}",
      options        => $server_options,
    },
    use_so_reuseport => true,
    nbproc           => 8,
  }
}
