class twitch::haproxy::listeners::usher_usher_testing (
  $haproxy_instance = 'usher',
  $proxy_name     = 'usher_testing',
  $servers        = [
    'usher998.sfo01.justin.tv:8000',
  ],
  $listen_port    = 8090,
  $remote_port    = 8925,
  $listen_address = '0.0.0.0',
  $server_options = 'check port 8001 inter 1000 maxconn 5',
  $settings       = {
    'maxconn'    => '52000',
    'mode'       => 'http',
    'log'        => 'global',
    'balance'    => 'roundrobin',
    'clitimeout' => '180000',
    'srvtimeout' => '180000',
    'contimeout' => '5000',
    'option'     => [
      'dontlog-normal',
      'httplog',
      'httpchk HEAD /alive HTTP/1.0',
    ],
  },
) {

  twitch_haproxy::listen{ $proxy_name:
    instance_name       => $haproxy_instance,
    ports               => $listen_port,
    default_remote_port => $remote_port,
    ipaddress           => $listen_address,
    options             => $settings,
    server_list         => $servers,
    server_options      => $server_options,
  }
}
