class twitch::haproxy::listeners::video_gatekeeper (
  $instance_name       = 'video_gatekeeper',
  $listener_name       = 'video_gatekeeper_http',
  $listen_address      = '*',
  $listen_port         = 4554,
  $remote_port_primary = 4555,
  $remote_port_backup  = 4556,
  $nbproc              = 1,
  $bind_processes      = 'all',
){
  $gatekeeper_options = {
    'mode'            => 'http',
    'monitor-uri'     => '/health',
    'timeout'         => [
      'http-request 10000',
    ],
    'option'          => [
      'httpchk HEAD /running',
      'http-keep-alive',
    ],
  }

  twitch_haproxy::listen{ $listener_name:
    instance_name       => $instance_name,
    ports               => $listen_port,
    default_remote_port => $remote_port_primary,
    ipaddress           => $listen_address,
    options             => $gatekeeper_options,
    use_so_reuseport    => true,
    nbproc              => $nbproc,
    bind_options        => ["process $bind_processes"],
    server_list         => [
      "127.0.0.1:${remote_port_primary} check inter 1s maxconn 10000",
      "127.0.0.1:${remote_port_backup} backup check inter 1s maxconn 10000",
    ],
  }
}
