class twitch::haproxy::listeners::video_weaver (
  $instance_name       = 'video_weaver',
  $listener_name       = 'video_weaver_http',
  $listen_address      = '*',
  $listen_port         = 7000,
  $remote_port_primary = 6000,
  $remote_port_backup  = 6001,
  $nbproc              = 1,
  $bind_processes      = 'all',
  $varnish_backend     = 'video_varnish_http',
){
  $weaver_options = {
    'mode'            => 'http',
    'monitor-uri'     => '/health',
    'monitor fail'    => 'if no_srv',
    'timeout'         => [
      'http-request 10000',
    ],
    'option'          => [
      'httpchk HEAD /health',
      'http-keep-alive',
    ],
    'acl'             => [
      'use_varnish path /crossdomain.xml',
      'no_srv nbsrv lt 1',
    ],
    'use_backend'     => [
      "${varnish_backend} if use_varnish",
    ],
  }

  twitch_haproxy::listen{ $listener_name:
    instance_name       => $instance_name,
    ports               => $listen_port,
    default_remote_port => $remote_port_primary,
    ipaddress           => $listen_address,
    options             => $weaver_options,
    use_so_reuseport    => true,
    nbproc              => $nbproc,
    bind_options        => ["process $bind_processes"],
    server_list         => [
      "127.0.0.1:${remote_port_primary} check inter 1s maxconn 10000",
      "127.0.0.1:${remote_port_backup} backup check inter 1s maxconn 10000",
    ],
  }
}
