class twitch::haproxy::listeners::web_rails_app_canary (
  $haproxy_instance = 'web',
  $proxy_name     = 'rails_app_canary',
  $listen_port    = 2011,
  $remote_port    = 7000,
  $listen_address = '127.0.0.1',
  $server_options = 'check inter 5000 weight 24',
  $settings       = {
    'maxconn'        => 32000,
    'log'            => 'global',
    'balance'        => 'leastconn',
    'mode'           => 'http',
    'clitimeout'     => '150000',
    'srvtimeout'     => '30000',
    'contimeout'     => '60000',
    'default-server' => 'maxconn 8 fall 1 rise 1 maxqueue 1',
    'option'         => [
      'httplog',
      'dontlog-normal',
      'dontlognull',
      'http-server-close',
      'forwardfor',
      'abortonclose',
      'httpchk HEAD /running/index HTTP/1.0',
      'redispatch',
    ]
  },
  $dc             = $::pop,
  $canary_suffix  = ''
) {

  twitch_haproxy::consul_listen{ $proxy_name:
    instance_name   => $haproxy_instance,
    ports           => $listen_port,
    ipaddress       => $listen_address,
    options         => $settings,
    consul_services => {
      service => "${twitchtv::consul_deploy_tag}-canary${canary_suffix}.web-rails-app@${dc}",
      health  => 'passing',
      options => $server_options
    },
  }
}
