class twitch::haproxy::live (
  $instname = 'live',
  $ingest_proxy_env = 'public',
  $stats_port = 2001,
  $global_options = {
    'user'         => 'www-data',
    'group'        => 'www-data',
    'daemon'       => '',
    'quiet'        => '',
    'pidfile'      => '/var/run/haproxy-live.pid',
    'maxconn'      => '32000',
    'chroot'       => '/var/chroot/haproxy',
    'nbproc'       => '6',
    'log-tag'      => 'haproxy_live',
    'log'          => '127.0.0.1 local3',
    'stats'        => 'socket /var/run/haproxy-live.stat user root group root mode 666 level operator',
  },
  $defaults_options = {
    'log'     => 'global',
    'mode'    => 'tcp',
    'balance' => 'roundrobin',
    'option'  => [
      'tcplog',
      'tcpka',
      'redispatch',
      'contstats',
    ],
    'timeout' => [
      'connect 5000',
      'server 180000',
      'client 180000',
    ]
  },
){

  twitch_haproxy::instance { $instname:
    defaults_options     => $defaults_options,
    global_options       => $global_options,
    stats_port           => $stats_port,
    with_consul_template => true,
    create_stats_sockets => true,
  }

  include twitch::haproxy::listeners::live_port_1935

  $consul_env = $::clean ? {
    true  => ["clean-${ingest_proxy_env}"],
    default => [$ingest_proxy_env],
  }

  consul::service { 'ingest-proxy':
    consul_tags => $consul_env,
    port        => 1935,
  }
}
