class twitch::haproxy::private (
  $instname   = 'private',
  $stats_port = 2001,
  $global_options = {
    'user'         => 'www-data',
    'group'        => 'www-data',
    'daemon'       => '',
    'quiet'        => '',
    'pidfile'      => '/var/run/haproxy-private.pid',
    'maxconn'      => '32000',
    'chroot'       => '/var/chroot/haproxy',
    'nbproc'       => '2',
    'log-tag'      => 'haproxy_private',
    'log'          => '127.0.0.1 local3',
    'stats'        => 'socket /var/run/haproxy-private.stat user root group root mode 666 level operator',
  },
  $defaults_options = {
    'log'     => 'global',
    'balance' => 'roundrobin',
    'mode'    => 'tcp',
    'option'  => [
      'allbackups',
      'tcplog',
      'tcpka',
      'redispatch',
      'contstats',
    ],
    'timeout' => [
      'connect 1000',
      'server 5000',
      'client 12000',
    ]
  },
){

  twitch_haproxy::instance { $instname:
    defaults_options     => $defaults_options,
    global_options       => $global_options,
    stats_port           => $stats_port,
    with_consul_template => true,
    create_stats_sockets => true,
  }

  include twitch::haproxy::listeners::private_port_1935
}
