class twitch::haproxy::services::rails (
  $http_host         = 'api.internal.twitch.tv',
) {
  include twitch::haproxy::backend
  include twitchtv

  $proxyname = 'rails-api'
  $port      = 4040

  twitch_haproxy::frontend { $proxyname:
    ports         => [$port],
    ipaddress     => ['127.0.0.1'],
    instance_name => $twitch::haproxy::backend::instance_name,
    options       => {
      'default_backend' => $proxyname,
      'mode'            => 'http',
      'reqidel'         => '^Host:.*',
      'reqadd'          => "Host:\ ${http_host}",
    },
  }

  twitch_haproxy::static_consul_backend { $proxyname:
    instance_name    => $twitch::haproxy::backend::instance_name,
    consul_services  => consul_service_lookup('web-rails-nginx', {
      'dc'  =>'sfo01',
      'tag' =>$twitchtv::consul_deploy_tag
    }),
    server_template  => "${module_name}/haproxy/services/rails_servers.erb",
    server_options   => 'fall 1 rise 2 check inter 5000 maxconn 5000',
    options          => {
      'mode'    => 'http',
      'maxconn' => '100000',
      'option'  => [
        "httpchk HEAD /running HTTP/1.1\\r\\nHost:\ ${http_host}",
        'http-server-close',
      ],
    },
    prefer_localhost => false,
  }
}
