class twitch::haproxy::telegraph (
  $instname        = 'telegraph',
  $stats_port      = 2001,
  $haproxy_maxconn = 524288,
  $global_options  = {
    'user'         => 'www-data',
    'group'        => 'www-data',
    'daemon'       => '',
    'quiet'        => '',
    'pidfile'      => '/var/run/haproxy-telegraph.pid',
    'maxconn'      => '524288',
    'chroot'       => '/var/chroot/haproxy',
    'nbproc'       => '2',
    'log-tag'      => 'haproxy_telegraph',
    'log'          => '127.0.0.1 local3',
    'tune.bufsize' => '8192',
    'stats'        => 'socket /var/run/haproxy-telegraph.stat user root group root mode 666 level operator',
  },
  $defaults_options = {
    'log'     => 'global',
    'balance' => 'roundrobin',
    'mode'    => 'tcp',
    'option'  => [
      'dontlog-normal',
      'tcplog',
      'tcpka',
      'redispatch',
      'contstats',
    ],
    'timeout' => [
      'connect 1000',
    ]
  },
){

  twitch_haproxy::instance { $instname:
    defaults_options => $defaults_options,
    global_options   => $global_options,
    stats_port       => $stats_port,
    haproxy_maxconn  => $haproxy_maxconn,
  }

  include twitch::haproxy::frontends::telegraph_frontend
  include twitch::haproxy::backends::telegraph_backend
}
