class twitch::haproxy::tenfoot(
  $listen_port,
  $blue_listen_port,
  $green_listen_port,
  $origin_port     = '9090',
  $default_backend = 'tenfoot-out',
  $instname        = 'tenfoot',
  $stats_port      = 2017,
  $global_options = {
    'user'         => 'www-data',
    'group'        => 'www-data',
    'daemon'       => '',
    'quiet'        => '',
    'pidfile'      => '/var/run/haproxy-tenfoot.pid',
    'maxconn'      => '4000',
    'chroot'       => '/var/chroot/haproxy',
    'nbproc'       => '2',
    'log-tag'      => 'haproxy_tenfoot',
    'log'          => '127.0.0.1 local3',
    'stats'        => 'socket /var/run/haproxy-tenfoot.stat user root group root mode 666 level operator',
  },
  $defaults_options = {
    'log'     => 'global',
    'balance' => 'roundrobin',
    'option'  => [
      'redispatch',
      'httplog',
    ],
    'timeout' => [
      'queue 500',
    ]
  },
) {
  twitch_haproxy::instance { $instname:
    defaults_options => $defaults_options,
    global_options   => $global_options,
    stats_port       => $stats_port,
  }

  class {'twitch::haproxy::frontends::tenfoot_in':
    listen_port     => $listen_port,
    default_backend => $default_backend,
  }
  class {'twitch::haproxy::backends::tenfoot_out':
    blue_listen_port     => $blue_listen_port,
    green_listen_port    => $green_listen_port,
  }
  # We're darklaunching the new video/origin service. It might not be running on
  # this host, but that's okay - we don't expect to send any requests to this
  # backend most of the time.
  class {'twitch::haproxy::backends::video_origin':
    haproxy_instance => $instname,
    port             => $origin_port,
  }
}
