# twitch::haproxy::tolive manages HAProxy for ingest proxy edge
class twitch::haproxy::tolive (
  $ensure                = 'present',
  $instname              = 'tolive',
  $stats_port            = 2001,
  $origin_pop            = 'sjc02',
  $origin_pop_key        = 'origin_pop',
  $enable_rtmps          = true,
) {
  $cpu_map = regsubst($::physicalprocessorrange, ',', ' ')
  $global_options = {
    'user'                      => 'www-data',
    'group'                     => 'www-data',
    'daemon'                    => '',
    'quiet'                     => '',
    'pidfile'                   => '/var/run/haproxy-tolive.pid',
    'maxconn'                   => '32000',
    'chroot'                    => '/var/chroot/haproxy',
    'nbproc'                    => $::processorcount / 2,
    'log-tag'                   => 'haproxy_tolive',
    'log'                       => '127.0.0.1 local3',
    'stats'                     => 'socket /var/run/haproxy-tolive.stat user root group root mode 666 level operator',
    'cpu-map'                   => "all ${cpu_map}",
    'tune.ssl.default-dh-param' => '2048',
    'ssl-default-bind-ciphers'  => hiera('ciphers::performance'),
    'ssl-default-bind-options'  => 'no-sslv3',
    'tune.ssl.cachesize'        => '80000',
  }

  $defaults_options = {
    'log'     => 'global',
    'mode'    => 'tcp',
    'balance' => 'roundrobin',
    'option'  => [
      'tcplog',
      'tcpka',
      'redispatch',
      'contstats',
      'log-health-checks',
    ],
    'timeout' => [
      'connect 5000',
      'server 30000',
      'client 40000',
    ],
  }

  twitch_haproxy::instance { $instname:
    ensure               => $ensure,
    defaults_options     => $defaults_options,
    global_options       => $global_options,
    stats_port           => $stats_port,
    with_consul_template => true,
    create_stats_sockets => true,
  }

  class { 'twitch::haproxy::frontends::tolive_rtmp':
    instance_name    => $instname,
    default_backend  => 'tolive_{{ $origin_pop }}',
    use_so_reuseport => true,
    nbproc           => $global_options['nbproc'],
    origin_pop_key   => $origin_pop_key,
  }

  if $ensure == 'present' and $enable_rtmps {
    class { 'twitch::haproxy::frontends::tolive_rtmps':
      instance_name    => $instname,
      default_backend  => 'tolive_{{ $origin_pop }}',
      use_so_reuseport => true,
      nbproc           => $global_options['nbproc'],
    }
  }

  twitch_haproxy::consul_backend { 'tolive_sjc02':
    instance_name   => $instname,
    server_options  => 'check send-proxy',
    consul_services => {
      'service' => 'production.ingest-proxy-lb@sjc02',
      'health'  => 'passing',
    },
    options         => {
      'mode'    => 'tcp',
      'maxconn' => '32000',
    },
  }

  twitch_haproxy::consul_backend { 'tolive_cmh01':
    instance_name   => $instname,
    server_options  => 'check send-proxy',
    consul_services => {
      'service' => 'production.ingest-proxy-lb@cmh01',
      'health'  => 'passing',
    },
    options         => {
      'mode'    => 'tcp',
      'maxconn' => '32000',
    },
  }

  twitch_haproxy::consul_backend { 'tolive_lhr05':
    instance_name   => $instname,
    server_options  => 'check send-proxy',
    consul_services => {
      'service' => 'production.ingest-proxy-lb@lhr05',
      'health'  => 'passing',
    },
    options         => {
      'mode'    => 'tcp',
      'maxconn' => '32000',
    },
  }

}
