class twitch::haproxy::usher_mmr_loadbalancer (
  $instname   = 'usher_mmr_lb',
  $stats_port = 2000,
  $consul     = true,
  $global_options = {
    'user'          => 'www-data',
    'group'         => 'www-data',
    'daemon'        => '',
    'quiet'         => '',
    'pidfile'       => '/var/run/haproxy-usher_mmr_lb.pid',
    'maxconn'       => '32000',
    'chroot'        => '/var/chroot/haproxy',
    'nbproc'        => '4',
    'log-tag'       => 'haproxy_usher_mmr_lb',
    'log'           => '127.0.0.1 local3',
    'stats'         => 'socket /var/run/haproxy-usher_mmr_lb.stat user root group root mode 666 level operator',
    'spread-checks' => '50',
  },
  $defaults_options = {
    'log'     => 'global',
    'balance' => 'roundrobin',
    'option'  => [
      'tcplog',
      'tcpka',
      'redispatch',
      'contstats'
    ],
    'timeout' => [
      'connect 5000',
      'server 180000',
      'client 180000'
    ]
  },
){

  twitch_haproxy::instance { $instname:
    defaults_options     => $defaults_options,
    global_options       => $global_options,
    stats_port           => $stats_port,
    with_consul_template => $consul,
  }


  class { 'twitch::haproxy::listeners::usher_mmr_lb_listener':
    haproxy_instance => $instname,
  }

}
