class twitch::haproxy::usher_origin (
  $listen_port = 8000,
  $ports,
  $instname,
  $consul_env,
  $consul_name = $instname,
  $stats_port  = 2020,
  $create_stats_sockets = true,
  $max_avg_queue = 100,
  $global_options = {
    'user'    => 'www-data',
    'group'   => 'www-data',
    'daemon'  => '',
    'quiet'   => '',
    'pidfile' => "/var/run/haproxy-${instname}.pid",
    'maxconn' => '32000',
    'chroot'  => '/var/chroot/haproxy',
    'nbproc'  => '1',
    'log-tag' => "haproxy-${instname}",
    'log'     => '127.0.0.1 local3',
  },
  $defaults_options = {
    'log'     => 'global',
    'balance' => 'roundrobin',
    'maxconn' => '32000',
    'option'  => [
      'tcplog',
      'tcpka',
      'redispatch',
      'contstats'
    ],
    'timeout' => [
      'queue 1000',
      'connect 5000',
      'server 180000',
      'client 180000'
    ]
  },
){

  twitch_haproxy::instance { $instname:
    defaults_options     => $defaults_options,
    global_options       => $global_options,
    stats_port           => $stats_port,
    create_stats_sockets => $create_stats_sockets,
  }

  if size($ports) / 2 < 1 {
    $min_backends = 1
  } else {
    $min_backends = size($ports) / 2
  }

  class { 'twitch::haproxy::frontends::usher_origin_check':
    instname      => $instname,
    min_backends  => $min_backends,
    max_avg_queue => $max_avg_queue,
  }
  class { 'twitch::haproxy::frontends::usher_origin':
    instname      => $instname,
    listen_port   => $listen_port,
    min_backends  => $min_backends,
    max_avg_queue => $max_avg_queue,
  }
  class { 'twitch::haproxy::backends::usher_origin':
    instname => $instname,
    ports    => $ports,
  }

  consul::service { $instname:
    service_name => $consul_name,
    consul_tags  => concat(['haproxy'], $consul_env),
    port         => $listen_port,
  }
}
